#ifndef __MT_UTILITIES_H__
#define __MT_UTILITIES_H__

#include <Quickdraw.h>

#define SET_RECT(theRect, l, t, r, b) { (theRect).left = (l); (theRect).top = (t); (theRect).right = (r); (theRect).bottom = (b); }
#define SET_RECT_PTR(theRect, l, t, r, b) { (theRect)->left = (l); (theRect)->top = (t); (theRect)->right = (r); (theRect)->bottom = (b); }
#define OFFSET_RECT(theRect, x, y)	{ (theRect).left += (x); (theRect).top += (y); (theRect).right += (x); (theRect).bottom += (y); }
#define OFFSET_RECT_PTR(theRect, x, y)	{ (theRect)->left += (x); (theRect)->top += (y); (theRect)->right += (x); (theRect)->bottom += (y); }

#define SWAP16(a)	((a) = (((a) >> 8) & 0x00FF) | (((a) << 8) & 0xFF00))
#define SWAP32(a)	((a) =	(((a) >> 24) & 0x000000FF) |	\
							(((a) >>  8) & 0x0000FF00) |	\
							(((a) <<  8) & 0x00FF0000) |	\
							(((a) << 24) & 0xFF000000))

#define SWAPRET16(a)	((((a) >> 8) & 0x00FF) | (((a) << 8) & 0xFF00))
#define SWAPRET32(a)	((((a) >> 24) & 0x000000FF) |	\
						(((a) >>  8) & 0x0000FF00) |	\
						(((a) <<  8) & 0x00FF0000) |	\
						(((a) << 24) & 0xFF000000))
class MTGrafPortSaver
{
	public:
				MTGrafPortSaver()						{ GetPort(&savePort); }
				MTGrafPortSaver(GrafPtr newPort)		{ GetPort(&savePort); SetPort(newPort); }
				MTGrafPortSaver(CGrafPtr newPort)		{ GetPort(&savePort); SetPort((GrafPtr)newPort); }
				MTGrafPortSaver(unsigned long newPort)	{ GetPort(&savePort); SetPort((GrafPtr)newPort); }
				~MTGrafPortSaver()						{ SetPort(savePort); }
	
	private:
		GrafPtr	savePort;
};

class MTFontStyle
{
	public:
				MTFontStyle();
				MTFontStyle(short id, short size, short face = 0, short mode = patOr);
				MTFontStyle(StringPtr inName, short size, short face = 0, short mode = patOr);
				MTFontStyle(char * inName, short size, short face = 0, short mode = patOr);
		
		void	CopyCurrent(void)		{ CopyCurrent(GetQDGlobalsThePort()); }
		void	CopyCurrent(CGrafPtr source);
		void	SetCurrent(void);
		void	SetCurrent(CGrafPtr target)	{ MTGrafPortSaver saver(target); SetCurrent(); }
		
		void	SetFont(short inID)		{ id = inID; dirty = 1; }
		void	SetSize(short inSize)	{ size = inSize; dirty = 1; }
		void	SetFace(short inFace)	{ face = inFace; dirty = 1; }
		void	SetMode(short inMode)	{ mode = inMode; dirty = 1; }
		
		SInt32	GetHeight(void)			{ Update(); return info.ascent; }
		SInt32	GetLineHeight(void)		{ Update(); return info.ascent + info.descent + info.leading; }
		SInt32	GetWidth(char * buf);
		SInt32	GetWidth(StringPtr buf);
	
	private:
		void	Update(void);
		
		void	LookupFontName(void);
		void	LookupSystemFontName(void)	{ GetFontName(systemFont, systemFontName); }
		
		Str255			name;
		
		short			id;
		short			size;
		short			face;
		short			mode;
		
		UInt8			dirty;
		
		FontInfo		info;
		
		static Str255	systemFontName;
		
		static const short	kNeedsFontNameLookup;
};

class MTFontSaver
{
	public:
		MTFontSaver()	{ data.CopyCurrent(); }
		~MTFontSaver()	{ data.SetCurrent(); }
	
	private:
		MTFontStyle	data;
};

class MTGWorldSaver
{
	public:
					MTGWorldSaver(GWorldPtr newWorld, GDHandle newDevice = nil)
					{
						GetGWorld(&saveWorld, &saveDevice);
						SetGWorld(newWorld, newDevice);
					}
					
					~MTGWorldSaver()	{ SetGWorld(saveWorld, saveDevice); }
	
	private:
		GWorldPtr	saveWorld;
		GDHandle	saveDevice;
};

const OSType			kApplicationCreator =	'MTRK';
const OSType			kPreferencesFileType =	'PREF';
const RGBColor			kBlackColor =			{0x0000, 0x0000, 0x0000};
const RGBColor			kDarkGrayColor =		{0x4444, 0x4444, 0x4444};
const RGBColor			kGrayColor =			{0x8888, 0x8888, 0x8888};
const RGBColor			kLightGrayColor =		{0xCCCC, 0xCCCC, 0xCCCC};
const RGBColor			kWhiteColor =			{0xFFFF, 0xFFFF, 0xFFFF};
const RGBColor			kRedColor =				{0xFFFF, 0x0000, 0x0000};
const RGBColor			kGreenColor =			{0x0000, 0xFFFF, 0x0000};
const RGBColor			kBlueColor =			{0x0000, 0x0000, 0xFFFF};

SInt32			Interpolate(SInt32 point, SInt32 startPoint, SInt32 endPoint, SInt32 startValue, SInt32 endValue);
float			InterpolateFloat(float point, float startPoint, float endPoint, float startValue, float endValue);
StringPtr		pstrcpy(StringPtr outDest, ConstStr255Param inSource);
StringPtr		pstrcat(StringPtr ioDest, ConstStr255Param inSource);
int				pstrcmp(StringPtr a, StringPtr b);
UInt8			CompareFSSpec(FSSpec * a, FSSpec * b);
UInt8 *			NewSizedPtr(UInt32 * size);
UInt32			NavigationPutFileCustom(FSSpec * outFile, StringPtr prompt, StringPtr name, UInt8 * isReplacing);
UInt32			NavigationGetFileCustom(FSSpec * outFile, StringPtr prompt);
void			PostProcessAEDescList(AEDescList * event, FSSpec * file);
pascal void		NavigationEventProc(NavEventCallbackMessage message, NavCBRecPtr params, NavCallBackUserData userData);

UInt32				GetCurrentModifierState(void);

inline UInt32		IsCommandKeyPressed(void)	{ return GetCurrentModifierState() & cmdKey; }
inline UInt32		IsShiftKeyPressed(void)		{ return GetCurrentModifierState() & (shiftKey | rightShiftKey); }
inline UInt32		IsCapsLockKeyPressed(void)	{ return GetCurrentModifierState() & alphaLock; }
inline UInt32		IsOptionKeyPressed(void)	{ return GetCurrentModifierState() & (optionKey | rightOptionKey); }
inline UInt32		IsControlKeyPressed(void)	{ return GetCurrentModifierState() & (controlKey | rightControlKey); }

inline UInt32 Convert16BitPixelTo32Bit(UInt32 data)
{
	UInt32	red, green, blue;
	
	red =	((data >> 10) & 0x1F) << 3;
	green =	((data >>  5) & 0x1F) << 3;
	blue =	((data >>  0) & 0x1F) << 3;
	
	return	(red << 16) | (green << 8) | (blue << 0);
}

inline UInt32 Convert32BitPixelTo16Bit(UInt32 data)
{
	UInt32	red, green, blue;
	
	red =	((data >> 16) & 0xFF) >> 3;
	green =	((data >>  8) & 0xFF) >> 3;
	blue =	((data >>  0) & 0xFF) >> 3;
	
	return	(red << 10) | (green << 5) | (blue << 0);
}

inline UInt32 Convert32BitPixelTo56516Bit(UInt32 data)
{
	UInt32	red, green, blue;
	
	red =	((data >> 16) & 0xFF) >> 3;
	green =	((data >>  8) & 0xFF) >> 2;
	blue =	((data >>  0) & 0xFF) >> 3;
	
	return	(red << 11) | (green << 5) | (blue << 0);
}

inline UInt32 CalculateColorDifference(UInt32 one, UInt32 two)
{
	UInt32	difference = 0;
	
	SInt32	valueOne, valueTwo;
	
	valueOne = ((one >>  0) & 0xFF);
	valueTwo = ((two >>  0) & 0xFF);
	difference += std::abs(valueOne - valueTwo);
	
	valueOne = ((one >>  8) & 0xFF);
	valueTwo = ((two >>  8) & 0xFF);
	difference += std::abs(valueOne - valueTwo);
	
	valueOne = ((one >> 16) & 0xFF);
	valueTwo = ((two >> 16) & 0xFF);
	difference += std::abs(valueOne - valueTwo);
	
	return difference;
}

#endif /* __MT_UTILITIES_H__ */